@echo off
title Geutebrueck Firewall Configuration
REM Firewall Configuration W7, W8x, Server 2008, Server 2012 Geutebrueck Ports 09th of January 2019 V2.31 U.Lister u. R.Sebastian u. L.Fuchs u. M.Hauk
REM This Version is for GeViScope, re_porter and new G-Core units
REM The Start Parameter /c will run this Script in "silent" Mode for Installation of G-Core software
REM The Start Parameter /g will run this Script in "silent" Mode for Production of GeViScope and re_porter units
REM The Start Parameter /u will run this Script in "silent" Mode for Uninstallation of G-Core software
REM The Start Parameter /s will run this Script in "silent" Mode for Installation of G-SIM software
REM The Start Parameter /v will run this Script in "silent" Mode for Uninstallation of G-SIM software
If "%1" =="/c" goto gcoreproduction
If "%1" =="/g" goto geviscopeproduction
If "%1" =="/u" goto gcoreuninstall
If "%1" =="/s" goto gsiminstall
If "%1" =="/v" goto gsimuninstall

goto menu


:menu


echo.***********************************************************************
echo.*                                                                     *
echo.*  Script to set up the advanced Firewall              V2.32          *
echo.*  of Windows 7+8+10, Vista, Server 2008(R2), Server 2012(R2)         *
echo.*                                                                     *
echo.*  1.) Enable   G-Core Ports                           21.) Disable   *
echo.*  2.) Enable   GeViScope Ports                        22.) Disable   *
echo.*  3.) Enable   G-SIM Ports                            23.) Disable   *
echo.*  4.) Enable   GeViSoft Ports                         24.) Disable   *
echo.*  5.) Enable   GeViSoft OPC                           25.) Disable   *
echo.*  6.) Enable   MBegGct LAN / CX III Port              26.) Disable   *
echo.*  7.) Enable   Cam2Ip Ports                           27.) Disable   *
echo.*  8.) Enable   File Sharing / Remote Desktop / Ping   28.) Disable   *
echo.*  9.) Enable   Multicast traffic                      29.) Disable   *
echo.* 10.) Enable   G-Link / G-Stats                       30.) Disable   *
echo * 11.) Enable   G-Health Ports in/out                  31.) Disable   *
echo *                                                                     *
echo.* 12.) Reset Firewall Settings to default                             *
echo.* 13.) Reset Firewall and keep Ports for Remote Desktop               *
echo.*                                                                     *
echo.*  Enter "Q" and press Return to leave Script                         *
echo.*                                                                     *
echo.*  (c) Geutebrueck GmbH 2022                                          *
echo.*                                                                     *
echo.***********************************************************************
echo.
set C=""
set /P C= Enter number and press Return  

If %C% == 1 goto enableg-coreports
If %C% == 2 goto enablegeviscopeports
If %C% == 3 goto enableG-SIMports
If %C% == 4 goto enablegevisoftports
If %C% == 5 goto enablegevisoftopc
If %C% == 6 goto enablembegport
If %C% == 7 goto enablecam2ipports
If %C% == 8 goto filesharing
If %C% == 9 goto Multicast
If %C% == 10 goto 10Glink
If %C% == 11 goto 12GHealthports
If %C% == 12 goto firewallreset
If %C% == 13 goto resetwithfilesharing
If %C% == 21 goto disableG-Coreports
If %C% == 22 goto disablegeviscopeports
If %C% == 23 goto disableG-SIMports
If %C% == 24 goto disablegevisoftports
If %C% == 25 goto disablegevisoftopc
If %C% == 26 goto disablembegport
If %C% == 27 goto disablecam2ipports
If %C% == 28 goto nofilesharing
If %C% == 29 goto 29nomulticast
If %C% == 30 goto 30noGlink
If %C% == 31 goto 32NoGHealthports
If %C% == Q goto eof
If %C% == q goto eof
If %C% == "" cls
If %C% == "" goto menu
cls
echo.
echo.
echo.***********************************************************************
echo.*                 Wrong Input - Press Return for Menu                 *
echo.***********************************************************************
echo.
pause >nul
cls
goto menu


REM G-Core Ports
:enableg-coreports
echo.Microsoft SQL Ports now added and enabled
echo.
netsh advfirewall firewall add rule name="G-Core Port 1433 TCP IN SQL-Server" dir=in action=allow description="G-Core MSSQL Port 1433 IN" enable=yes profile=any localport=1433 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 1434 UDP IN SQL-Browser" dir=in action=allow description="G-Core MSSQL Browser UDP Port 1434 IN" enable=yes profile=any localport=1434 remoteport=any protocol=UDP

echo.G-Core Ports now added and enabled
echo.


netsh advfirewall firewall add rule name="G-Core Port 80 TCP IN" dir=in action=allow description="G-Web Port 80 IN" enable=no profile=any localport=80 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13003 TCP IN" dir=in action=allow description="GscView & GscSetup Port 13003 IN" enable=yes profile=any localport=13003 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13003 TCP OUT" dir=out action=allow description="GscView & GscSetup Port 13003 OUT" enable=yes profile=any localport=13003 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13003 UDP IN ServerList" dir=in action=allow description="G-Core Serverlist UDP Port 13003 IN" enable=yes profile=any localport=13003 remoteport=any protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 13003 UDP OUT ServerList" dir=out action=allow description="G-Core Serverlist UDP Port 13003 OUT" enable=yes profile=any localport=13003 remoteport=any protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 13004 TCP IN" dir=in action=allow description="GscMediaAPI Port 13004 IN" enable=yes profile=any localport=13004 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13004 TCP OUT" dir=out action=allow description="GscMediaAPI Port 13004 OUT" enable=no profile=any localport=13004 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13005 TCP IN" dir=in action=allow description="G-Core RemotePlugin Port 13005 IN" enable=yes profile=any localport=13005 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13005 TCP OUT" dir=out action=allow description="G-Core RemotePlugin Port 13005 OUT" enable=no profile=any localport=13005 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13007 TCP IN" dir=in action=allow description="G-Core Action Server Port 13007 IN" enable=no profile=any localport=13007 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13008 UDP IN SAMList" dir=in action=allow description="G-CoreSAMList Port 13008 UDP IN" enable=yes profile=any localport=13008 remoteport=any protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 13008 TCP IN" dir=in action=allow description="G-Core SAM / Licence Port 13008 IN" enable=yes profile=any localport=13008 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13010 TCP IN" dir=in action=allow description="G-Core Scan Connect Port 13010 IN" enable=no profile=any localport=13010 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13011 TCP IN" dir=in action=allow description="G-Core P2P / IPC Finding Port 13011 IN" enable=yes profile=any localport=13011 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13011 UDP IN" dir=in action=allow description="G-Core P2P / IPC Finding Port 13011 IN" enable=yes profile=any localport=13011 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="G-Core Port 13011 TCP IN" dir=in action=allow description="G-Core P2P / IPC Finding Port 13011 IN" enable=no profile=any localport=13011 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Tect FailoverSetup Port 13220 TCP IN" dir=in action=allow description="G-Tect FailoverSetup Port 13220 IN" enable=Yes profile=any localport=13220 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Tect FailoverSetup Port 13220 TCP OUT" dir=out action=allow description="G-Tect FailoverSetup Port 13220 OUT" enable=Yes profile=any localport=13220 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Tect Failover Status Port 13221 TCP IN" dir=in action=allow description="G-Tect Failover Status Port 13221 IN" enable=Yes profile=any localport=13221 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Tect AI Data Port 13222 TCP IN" dir=in action=allow description="G-Tect AI Data Port 13222 IN" enable=Yes profile=any localport=13222 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13032 TCP IN" dir=in action=allow description="G-Core GngTCServerPort Port 13032 IN" enable=no profile=any localport=13032 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13033 TCP IN" dir=in action=allow description="G-Core GngTCServerWebStreamPort Port 13033 IN" enable=no profile=any localport=13033 remoteport=any protocol=tcp

REM G-Streamer Rules were added in early installations before 01.04.2015 and will be deleted because product renamed.
echo.

netsh advfirewall firewall delete rule name="all" dir=in profile=any localport=13015 remoteport=any protocol=tcp
netsh advfirewall firewall delete rule name="all" dir=in profile=any localport=13016 remoteport=any protocol=tcp
netsh advfirewall firewall delete rule name="all" dir=in profile=any localport=13017 remoteport=any protocol=tcp
netsh advfirewall firewall delete rule name="all" dir=in profile=any localport=13018 remoteport=any protocol=tcp

REM add G-Core Streamer Ports because available since Release 1.3.8.42
echo.G-Core Streamer Ports added but disabled
echo.
netsh advfirewall firewall add rule name="G-Core Port 13015 TCP IN Streamer Channel 01" dir=in action=allow description="G-Core/Streamer Port 13015 IN" enable=no profile=any localport=13015 remoteport=any protocol=tcp
netsh advfirewall firewall add rule name="G-Core Port 13016 TCP IN Streamer Channel 02" dir=in action=allow description="G-Core/Streamer Port 13016 IN" enable=no profile=any localport=13016 remoteport=any protocol=tcp
netsh advfirewall firewall add rule name="G-Core Port 13017 TCP IN Streamer Channel 03" dir=in action=allow description="G-Core/Streamer Port 13017 IN" enable=no profile=any localport=13017 remoteport=any protocol=tcp
netsh advfirewall firewall add rule name="G-Core Port 13018 TCP IN Streamer Channel 04" dir=in action=allow description="G-Core/Streamer Port 13018 IN" enable=no profile=any localport=13018 remoteport=any protocol=tcp


netsh advfirewall firewall add rule name="G-Core Port 13020 TCP IN" dir=in action=allow description="G-Core APF Port 13020 IN" enable=yes profile=any localport=13020 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13030 TCP IN" dir=in action=allow description="G-Core Imex Config Port 13030 IN" enable=yes profile=any localport=13030 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13040 TCP IN" dir=in action=allow description="G-Core HTTP Info Port 13040 IN" enable=yes profile=any localport=13040 remoteport=any protocol=tcp

echo. add and enable IPCFinding Ports
echo.

netsh advfirewall firewall add rule name="G-Core Port 13050 TCP IN" dir=in action=allow description="G-Core TopLine finding Port 13050 IN" enable=yes profile=any localport=13050 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13060 TCP IN" dir=in action=allow description="G-Core Sony finding Port 13060 IN" enable=yes profile=any localport=13060 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13062 TCP IN" dir=in action=allow description="G-Core ONVIF G-Core finding Port 13062 IN" enable=yes profile=any localport=13062 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13063 TCP IN" dir=in action=allow description="G-Core ONMVIF G-Finder finding Port 13063 IN" enable=yes profile=any localport=13063 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13064 TCP IN" dir=in action=allow description="G-Core ArecontVision G-Core finding Port 13064 IN" enable=yes profile=any localport=13064 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13065 TCP IN" dir=in action=allow description="G-Core ArecontVision G-Finder finding Port 13065 IN" enable=yes profile=any localport=13065 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 69 TCP OUT" dir=out action=allow description="G-Core ArecontVision finding broadcast Port 69 OUT" enable=yes profile=any localport=69 remoteport=any protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 2869 UPNP OUT" dir=out action=allow description="G-Core UPNP Remote Port 2869 OUT" enable=yes profile=any localport=any remoteport=2869 protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 1900 SSDP OUT" dir=out action=allow description="G-Core SSDP Remote Port 1900 OUT" enable=yes profile=any localport=any remoteport=1900 protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 2380 UDP OUT" dir=out action=allow description="G-Core Sony Cameras Remote Port 2380 UDP OUT" enable=yes profile=any localport=any remoteport=2380 protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 2575 UDP OUT" dir=out action=allow description="G-Core TopLine Cameras Remote Port 2575 UDP OUT" enable=yes profile=any localport=any remoteport=2575 protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 3702 UDP OUT" dir=out action=allow description="G-Core ONVIF Cameras Remote Port 3702 UDP OUT" enable=yes profile=any localport=any remoteport=3702 protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 5353 UDP OUT" dir=out action=allow description="G-Core AXIS / E2 MDNS Remote Port 5353 UDP OUT" enable=yes profile=any localport=any remoteport=5353 protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 6666 UDP OUT" dir=out action=allow description="G-Core E3 / GNSD Remote Port 6666 UDP OUT" enable=yes profile=any localport=any remoteport=6666 protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 7777 TCP IN" dir=in action=allow  description="G-Core ActionGate 7777 IN" enable=yes profile=any localport=7777 remoteport=any protocol=TCP 

netsh advfirewall firewall add rule name="G-Core Port 7777 TCP OUT" dir=out action=allow  description="G-Core ActionGate 7777 OUT" enable=yes profile=any localport=any remoteport=7777 protocol=TCP 

REM add for CamCheck service

netsh advfirewall firewall add rule name="G-SIM CCS CamCheck 13200 TCP IN" dir=in action=allow description="CamCheck 13200 TCP IN" enable=yes profile=any localport=13200 remoteport=any protocol=tcp

echo. Done - Press Return for Menu
pause >nul
cls
goto menu

:disableG-Coreports
echo.disable G-Core Ports now
echo.

netsh advfirewall firewall set rule name="G-Core Port 13003 TCP IN" new enable=no

echo.Microsoft SQL Ports now disabled
echo.
netsh advfirewall firewall set rule name="G-Core Port 1433 TCP IN SQL-Server" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 1434 UDP IN SQL-Browser" new enable=no


echo.G-Core Ports now disabled
echo.

netsh advfirewall firewall set rule name="G-Core Port 80 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13003 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13003 TCP OUT" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13003 UDP IN ServerList" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13003 UDP OUT ServerList" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13004 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13004 TCP OUT" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13005 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13005 TCP OUT" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13007 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13008 UDP IN SAMList" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13008 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13010 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13011 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13011 UDP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13015 TCP IN Streamer Channel 01" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13016 TCP IN Streamer Channel 02" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13017 TCP IN Streamer Channel 03" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13018 TCP IN Streamer Channel 04" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13020 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13030 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13032 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13033 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13040 TCP IN" new enable=no



netsh advfirewall firewall set rule name="G-Core Port 443 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Tect FailoverSetup Port 13220 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Tect FailoverSetup Port 13220 TCP OUT" new enable=no

netsh advfirewall firewall set rule name="G-Tect Failover Status Port 13221 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Tect AI Data Port 13222 TCP IN" new enable=no

echo. disable IPCFinding Ports
echo.

netsh advfirewall firewall set rule name="G-Core Port 13050 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13060 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13062 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13063 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13064 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 13065 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 69 TCP OUT" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 2869 UPNP OUT" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 1900 SSDP OUT" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 2380 UDP OUT" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 2575 UDP OUT" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 3702 UDP OUT" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 5353 UDP OUT" new enable=no

netsh advfirewall firewall set rule name="G-Core Port 6666 UDP OUT" new enable=no

netsh advfirewall firewall set rule name="G-SIM CCS CamCheck 13200 TCP IN" new enable=no

REM echo.disable G-Streamer Ports now
REM echo.
REM netsh advfirewall firewall set rule name="G-Streamer Channel 01 OUT" new enable=no
REM netsh advfirewall firewall set rule name="G-Streamer Channel 02 OUT" new enable=no
REM netsh advfirewall firewall set rule name="G-Streamer Channel 03 OUT" new enable=no
REM netsh advfirewall firewall set rule name="G-Streamer Channel 04 OUT" new enable=no
REM marked out because Streamer will not be available for G-Core any more and will be replaced by G-Web


echo. Done - Press Return for Menu
pause >nul
cls
goto menu

REM GeViScope Ports
:enablegeviscopeports
echo.GeViScope Ports now added and enabled
echo.
netsh advfirewall firewall add rule name="GeViScope Port 12003 TCP IN" dir=in action=allow description="GscView & GscSetup Port 12003 IN" enable=yes profile=any localport=12003 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViScope Port 12003 TCP OUT" dir=out action=allow description="GscView & GscSetup Port 12003 OUT" enable=yes profile=any localport=12003 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GscServerList Port 12003 UDP IN" dir=in action=allow description="GeViScope Serverlist UDP Port 12003 IN" enable=yes profile=any localport=12003 remoteport=any protocol=UDP

netsh advfirewall firewall add rule name="GscServerList Port 12003 UDP OUT" dir=out action=allow description="GeViScope Serverlist UDP Port 12003 OUT" enable=no profile=any localport=12003 remoteport=any protocol=UDP

netsh advfirewall firewall add rule name="GeViScope Port 12004 TCP IN" dir=in action=allow description="GscMediaAPI Port 12004 IN" enable=yes profile=any localport=12004 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViScope Port 12004 TCP OUT" dir=out action=allow description="GscMediaAPI Port 12004 OUT" enable=no profile=any localport=12004 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViScope Port 12005 TCP IN" dir=in action=allow description="GeViScope RemotePlugin Port 12005 IN" enable=yes profile=any localport=12005 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViScope Port 12005 TCP OUT" dir=out action=allow description="GeViScope RemotePlugin Port 12005 OUT" enable=no profile=any localport=12005 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViScope Port 12007 TCP IN" dir=in action=allow description="GeViScope TACI Port 12007 IN" enable=yes profile=any localport=12007 remoteport=any protocol=tcp


netsh advfirewall firewall add rule name="GeViScope Port 12008 TCP IN" dir=in action=allow description="GeViScope Licence Port 12008 IN" enable=yes profile=any localport=12008 remoteport=any protocol=tcp
netsh advfirewall firewall add rule name="GeViScope Port 1209 TCP IN" dir=in action=allow description="GeViScope Licence Port 1209 IN" enable=yes profile=any localport=1209 remoteport=any protocol=tcp

echo.GscStreamer Ports added but disabled
echo.
netsh advfirewall firewall add rule name="GscStreamer Channel 01 IN" dir=in action=allow description="GscStreamer Port 12015 IN" enable=no profile=any localport=12015 remoteport=any protocol=tcp
netsh advfirewall firewall add rule name="GscStreamer Channel 02 IN" dir=in action=allow description="GscStreamer Port 12016 IN" enable=no profile=any localport=12016 remoteport=any protocol=tcp
netsh advfirewall firewall add rule name="GscStreamer Channel 03 IN" dir=in action=allow description="GscStreamer Port 12017 IN" enable=no profile=any localport=12017 remoteport=any protocol=tcp
netsh advfirewall firewall add rule name="GscStreamer Channel 04 IN" dir=in action=allow description="GscStreamer Port 12018 IN" enable=no profile=any localport=12018 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViScope Port 12020 TCP IN" dir=in action=allow description="GeViScope APF Port 12020 IN" enable=yes profile=any localport=12020 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViScope Port 80 TCP IN" dir=in action=allow description="GeViScope Web Port 80 IN" enable=no profile=any localport=80 remoteport=any protocol=tcp

REM Axis Camera Event Notification Port

echo.AXIS Camera Event Port now added
echo.
netsh advfirewall firewall add rule name="Axis Camera Port 12006 TCP IN" dir=in action=allow description="Axis Camera Event Notification Port 12006 IN" enable=yes profile=any localport=12006 remoteport=any protocol=tcp
echo. Done - Press Return for Menu
pause >nul
cls
goto menu


:disablegeviscopeports
echo.disable GeViScope Ports now
echo.

netsh advfirewall firewall set rule name="GeViScope Port 12003 TCP IN" new enable=no

netsh advfirewall firewall set rule name="GeViScope Port 12003 TCP OUT" new enable=no

netsh advfirewall firewall set rule name="GscServerList Port 12003 UDP IN" new enable=no

netsh advfirewall firewall set rule name="GscServerList Port 12003 UDP OUT" new enable=no

netsh advfirewall firewall set rule name="GeViScope Port 12004 TCP IN" new enable=no

netsh advfirewall firewall set rule name="GeViScope Port 12004 TCP OUT" new enable=no

netsh advfirewall firewall set rule name="GeViScope Port 12005 TCP IN" new enable=no

netsh advfirewall firewall set rule name="GeViScope Port 12005 TCP OUT" new enable=no

netsh advfirewall firewall set rule name="GeViScope Port 12007 TCP IN" new enable=no


netsh advfirewall firewall set rule name="GeViScope Port 12008 TCP IN" new enable=no

netsh advfirewall firewall set rule name="GeViScope Port 1209 TCP IN" new enable=no

echo.disable GscStreamer Ports now
echo.

netsh advfirewall firewall set rule name="GscStreamer Channel 01 OUT" new enable=no

netsh advfirewall firewall set rule name="GscStreamer Channel 02 OUT" new enable=no

netsh advfirewall firewall set rule name="GscStreamer Channel 03 OUT" new enable=no

netsh advfirewall firewall set rule name="GscStreamer Channel 04 OUT" new enable=no

netsh advfirewall firewall set rule name="GeViScope Port 12020 TCP IN" new enable=no


netsh advfirewall firewall set rule name="GeViScope Port 80 TCP IN" new enable=no

REM Axis Camera Event Notification Port

echo. disable AXIS Camera Event Port now
echo.

netsh advfirewall firewall set rule name="Axis Camera Port 12006 TCP IN" new enable=no
echo. Done - Press Return for Menu
pause >nul
cls
goto menu

REM G-SIM Ports
:enableG-SIMports
echo.G-SIM Ports now added and enabled
echo.
netsh advfirewall firewall add rule name="G-SIM Port 8090 TCP IN" dir=in action=allow description="G-SIM Server Port 8090 IN" enable=yes profile=any localport=8090 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-SIM Port 8091 TCP IN" dir=in action=allow description="G-SIM Synch Port 8091 IN" enable=yes profile=any localport=8091 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-SIM Process Data Port 8092 TCP IN" dir=in action=allow description="G-SIM Port 8092 IN" enable=yes profile=any localport=8092 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-SIM Port 8098 TCP IN" dir=in action=allow description="G-SIM SAM Proxy Port 8098 IN" enable=yes profile=any localport=8098 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-SIM Port 8099 TCP IN" dir=in action=allow description="G-SIM Agent Port 8099 IN" enable=yes profile=any localport=8099 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-SIM Port 8099 UDP IN" dir=in action=allow description="G-SIM Health Agent Cluster Port UDP 8099 IN" enable=yes profile=any localport=8099 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="G-Sim Port 13100 Active Directory TCP IN" dir=in action=allow description="G-Sim Port 13100 AD Routing Service TCP IN" enable=yes profile=any localport=13100 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Sim Port 13110 Active Directory TCP IN" dir=in action=allow description="G-Sim Port 13110 AD Service TCP IN" enable=yes profile=any localport=13110 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Sim Port 13180 Export Service TCP IN" dir=in action=allow description="G-Sim Port 13180 Export Service TCP IN" enable=yes profile=any localport=13180 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-SIM Port 13210 AppInstance Mgr TCP IN" dir=in action=allow description="G-SIM Port 13210 AppInstance Mgr TCP IN" enable=yes profile=any localport=13210 remoteport=any protocol=tcp

echo. Done - Press Return for Menu
pause >nul
cls
goto menu


:disableG-SIMports
echo.G-SIM Ports now disabled
echo.
netsh advfirewall firewall set rule name="G-SIM Port 8090 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-SIM Port 8091 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-SIM Process Data Port 8092 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-SIM Port 8098 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-SIM Port 8099 TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Sim Port 13100 Active Directory TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Sim Port 13110 Active Directory TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-Sim Port 13180 Export Service TCP IN" new enable=no

netsh advfirewall firewall set rule name="G-SIM Port 13210 AppInstance Mgr TCP IN" new enable=no

echo. Done - Press Return for Menu
pause >nul
cls
goto menu


REM GeViSoft Ports
:enablegevisoftports
echo.GeViSoft Ports now added and enabled
echo.
netsh advfirewall firewall add rule name="GeViSoft Port 7700 TCP IN" dir=in action=allow description="GeViSoft Port 7700 IN" enable=yes profile=any localport=7700 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViSoft Port 7701 TCP IN" dir=in action=allow description="GeViSoft Port 7701 IN" enable=yes profile=any localport=7701 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViSoft Port 7704 UDP IN" dir=in action=allow description="GeViServer Port 7704 UDP IN" enable=yes profile=any localport=7704 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="GeViSoft Port 7705 UDP IN" dir=in action=allow description="GeViIo Port 7705 UDP IN" enable=yes profile=any localport=7705 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="GeViSoft Port 7703 TCP IN" dir=in action=allow description="GeViSoft Port 7703 IN" enable=yes profile=any localport=7703 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViSoft Port 7800 TCP IN" dir=in action=allow description="GeViSoft Port 7800 IN" enable=yes profile=any localport=7800 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViSoft Port 7801 TCP IN" dir=in action=allow description="GeViSoft Port 7801 IN" enable=yes profile=any localport=7801 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViSoft Port 7803 TCP IN" dir=in action=allow description="GeViSoft Port 7803 IN" enable=yes profile=any localport=7803 remoteport=any protocol=tcp


netsh advfirewall firewall add rule name="GeViSoft Manager IN" dir=in action=allow program="c:\gevisoft\geviadmin.exe" description="GeViSoft Manager IN" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoft Manager OUT" dir=out action=allow program="c:\gevisoft\geviadmin.exe" description="GeViSoft Manager OUT" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoft GeViSet IN" dir=in action=allow program="c:\gevisoft\geviset.exe" description="GeViSoft GeViSet IN" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoft GeViSet OUT" dir=out action=allow program="c:\gevisoft\geviset.exe" description="GeViSoft GeViSet OUT" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoft GeViRedMonitor IN" dir=in action=allow program="c:\gevisoft\geviredmonitor.exe" description="GeViSoft Redundanz Monitor IN" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoft GeViRedMonitor OUT" dir=out action=allow program="c:\gevisoft\geviredmonitor.exe" description="GeViSoft Redundanz Monitor OUT" enable=yes profile=any

echo. Done - Press Return for Menu
pause >nul
cls
goto menu


:disablegevisoftports
echo.disable GeViSoft Ports now
echo.
netsh advfirewall firewall set rule name="GeViSoft Port 7700 TCP IN" new enable=no

netsh advfirewall firewall set rule name="GeViSoft Port 7701 TCP IN" new enable=no

netsh advfirewall firewall set rule name="GeViSoft Port 7704 UDP IN" new enable=no

netsh advfirewall firewall set rule name="GeViSoft Port 7705 UDP IN" new enable=no

netsh advfirewall firewall set rule name="GeViSoft Port 7703 TCP IN" new enable=no

netsh advfirewall firewall set rule name="GeViSoft Port 7800 TCP IN" new enable=no

netsh advfirewall firewall set rule name="GeViSoft Port 7801 TCP IN" new enable=no

netsh advfirewall firewall set rule name="GeViSoft Port 7803 TCP IN" new enable=no


netsh advfirewall firewall set rule name="GeViSoft Manager IN" new enable=no

netsh advfirewall firewall set rule name="GeViSoft Manager OUT" new enable=no

netsh advfirewall firewall set rule name="GeViSoft GeViSet IN" new enable=no

netsh advfirewall firewall set rule name="GeViSoft GeViSet OUT" new enable=no

netsh advfirewall firewall set rule name="GeViSoft GeViRedMonitor IN" new enable=no

netsh advfirewall firewall set rule name="GeViSoft GeViRedMonitor OUT" new enable=no
echo. Done - Press Return for Menu
pause >nul
cls
goto menu


REM enable GeViSoft OPC Configuration. Customer Software needs to added manually
:enablegevisoftopc
echo.GeViSoft OPC Connections now added and enabled
echo.
netsh advfirewall firewall add rule name="GeViSoft OPC Port 135 TCP IN" dir=in action=allow description="GeViSoft OPC Port 135 IN" enable=yes profile=any localport=135 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViSoft OPC Port 135 UDP IN" dir=in action=allow description="GeViServer OPC Port 135 UDP IN" enable=yes profile=any localport=135 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="GeViSoft OPC Port 135 TCP OUT" dir=out action=allow description="GeViSoft OPC Port 135 OUT" enable=yes profile=any localport=135 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViSoft OPC Port 135 UDP OUT" dir=out action=allow description="GeViServer OPC Port 135 UDP OUT" enable=yes profile=any localport=135 remoteport=any protocol=udp


netsh advfirewall firewall add rule name="GeViSoft OPCEnum IN" dir=in action=allow program="%windir\system32\opcenum.exe" description="GeViSoft OPCEnum IN" enable=yes profile=any

netsh advfirewall firewall add rule name="dOPCExplorer IN" dir=in action=allow program="c:\gevisoft\dopcexplorer.exe" description="dOPCExplorer IN" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoftServer IN" dir=in action=allow program="c:\gevisoft\geviserver.exe" description="GeViSoftServer IN" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoft OPCEnum OUT" dir=out action=allow program="%windir\system32\opcenum.exe" description="GeViSoft OPCEnum OUT" enable=yes profile=any

netsh advfirewall firewall add rule name="dOPCExplorer OUT" dir=out action=allow program="c:\gevisoft\dopcexplorer.exe" description="dOPCExplorer OUT" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoftServer OUT" dir=out action=allow program="c:\gevisoft\geviserver.exe" description="GeViSoftServer OUT" enable=yes profile=any
echo. Done - Press Return for Menu
pause >nul
cls
goto menu


:disablegevisoftopc
echo.Disable GeViSoft OPC Connections now
netsh advfirewall firewall set rule name="GeViSoft OPC Port 135 TCP IN" new enable=no

netsh advfirewall firewall set rule name="GeViSoft OPC Port 135 UDP IN" new enable=no

netsh advfirewall firewall set rule name="GeViSoft OPC Port 135 TCP OUT" new enable=no

netsh advfirewall firewall set rule name="GeViSoft OPC Port 135 UDP OUT" new enable=no

netsh advfirewall firewall set rule name="GeViSoft OPCEnum IN" new enable=no

netsh advfirewall firewall set rule name="dOPCExplorer IN" new enable=no

netsh advfirewall firewall set rule name="GeViSoft OPCEnum OUT" new enable=no

netsh advfirewall firewall set rule name="dOPCExplorer OUT" new enable=no

netsh advfirewall firewall set rule name="GeViSoftServer IN" new enable=no

netsh advfirewall firewall set rule name="GeViSoftServer OUT" new enable=no
echo. Done - Press Return for Menu
pause >nul
cls
goto menu


REM Xport Geutebrueck Serial line terminal server module MBeg,CX3
:enablembegport

echo.Geutebrueck MBegLan Port now added and enabled
echo.
netsh advfirewall firewall add rule name="XPort Port 10001 IN" dir=in action=allow description="MBegGct & CX3 XPort Port 10001 IN" enable=yes profile=any localport=10001 remoteport=any protocol=tcp
echo. Done - Press Return for Menu
pause >nul
cls
goto menu


:disablembegport
echo.disable Geutebrueck MBegLan Port now
echo.
netsh advfirewall firewall set rule name="XPort Port 10001 IN" new enable=no
echo. Done - Press Return for Menu
pause >nul
cls
goto menu


REM Cam2IP Ports
:enablecam2ipports
echo.Cam2Ip Ports now added and enabled
echo.
netsh advfirewall firewall add rule name="Cam2Ip Port 12010 TCP IN" dir=in action=allow description="Cam2Ip Port 12010 IN" enable=yes profile=any localport=12010 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="Cam2Ip Port 12011 TCP IN" dir=in action=allow description="Cam2Ip Port 12011 IN" enable=yes profile=any localport=12011 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="Cam2Ip Port 12012 TCP IN" dir=in action=allow description="Cam2Ip Port 12012 IN" enable=yes profile=any localport=any remoteport=12012 protocol=tcp

netsh advfirewall firewall add rule name="Cam2Ip Port 12013 TCP IN" dir=in action=allow description="Cam2Ip Port 12013 IN" enable=yes profile=any localport=any remoteport=12013 protocol=tcp

netsh advfirewall firewall add rule name="Cam2Ip Port 12011 UDP IN" dir=in action=allow description="Cam2Ip Port 12011 IN" enable=yes profile=any localport=12011 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="Cam2Ip Port 12012 UDP IN" dir=in action=allow description="Cam2Ip Port 12012 IN" enable=yes profile=any localport=12012 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="Cam2Ip Port 12013 UDP IN" dir=in action=allow description="Cam2Ip Port 12013 IN" enable=yes profile=any localport=12013 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="Cam2Ip Port 12014 UDP IN" dir=in action=allow description="Cam2Ip Devicelist Port 12014 IN for Device List" enable=yes profile=any localport=12014 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="Cam2Ip Port 12010 UDP OUT" dir=out action=allow description="Cam2Ip Devicelist Port 12010 OUT for Device List" enable=yes profile=any localport=12010 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="Cam2Ip Port 12014 UDP OUT" dir=out action=allow description="Cam2Ip Devicelist Port 12014 OUT for Device List" enable=yes profile=any localport=12014 remoteport=any protocol=udp

echo. Done - Press Return for Menu
pause >nul
cls
goto menu


:disablecam2ipports
echo.Cam2Ip Ports now added and disabled
echo.
netsh advfirewall firewall set rule name="Cam2Ip Port 12010 TCP IN" new enable=no

netsh advfirewall firewall set rule name="Cam2Ip Port 12011 TCP IN" new enable=no

netsh advfirewall firewall set rule name="Cam2Ip Port 12012 TCP IN" new enable=no

netsh advfirewall firewall set rule name="Cam2Ip Port 12013 TCP IN" new enable=no

netsh advfirewall firewall set rule name="Cam2Ip Port 12011 UDP IN" new enable=no

netsh advfirewall firewall set rule name="Cam2Ip Port 12012 UDP IN" new enable=no

netsh advfirewall firewall set rule name="Cam2Ip Port 12013 UDP IN" new enable=no

netsh advfirewall firewall set rule name="Cam2Ip Port 12014 UDP IN" new enable=no

netsh advfirewall firewall set rule name="Cam2Ip Port 12010 UDP OUT" new enable=no

netsh advfirewall firewall set rule name="Cam2Ip Port 12014 UDP OUT" new enable=no
echo. Done - Press Return for Menu
pause >nul
cls
goto menu


REM Netbios enable
:filesharing
netsh advfirewall firewall set rule name=all profile=private localport=137 remoteport=any protocol=udp new enable=yes
netsh advfirewall firewall set rule name=all profile=public localport=137 remoteport=any protocol=udp new enable=yes

netsh advfirewall firewall set rule name=all profile=private localport=138 remoteport=any protocol=udp new enable=yes
netsh advfirewall firewall set rule name=all profile=public localport=138 remoteport=any protocol=udp new enable=yes

netsh advfirewall firewall set rule name=all profile=private localport=139 remoteport=any protocol=tcp new enable=yes
netsh advfirewall firewall set rule name=all profile=public localport=139 remoteport=any protocol=tcp new enable=yes


REM Remotedesktop enable
netsh advfirewall firewall set rule name=all dir=in profile=any localport=3389 remoteport=any protocol=tcp new enable=yes

REM Ping Echo Request enable
REM following line for server 2008 doesnt match on W7
netsh advfirewall firewall set rule name=all dir=in profile=any protocol=icmpv4:8,any new enable=yes
REM for W7 old command line which bring up a message but works
netsh firewall set icmpsetting 8 enable
echo. Done - Press Return for Menu
pause >nul
cls
goto menu


:nofilesharing
REM Netbios enable
netsh advfirewall firewall set rule name=all profile=private localport=137 remoteport=any protocol=udp new enable=no
netsh advfirewall firewall set rule name=all profile=public localport=137 remoteport=any protocol=udp new enable=no

netsh advfirewall firewall set rule name=all profile=private localport=138 remoteport=any protocol=udp new enable=no
netsh advfirewall firewall set rule name=all profile=public localport=138 remoteport=any protocol=udp new enable=no

netsh advfirewall firewall set rule name=all profile=private localport=139 remoteport=any protocol=tcp new enable=no
netsh advfirewall firewall set rule name=all profile=public localport=139 remoteport=any protocol=tcp new enable=no


REM Remotedesktop disable
netsh advfirewall firewall set rule name=all dir=in profile=any localport=3389 remoteport=any protocol=tcp new enable=no

REM Ping Echo Request disable
REM following line for server 2008 doesnt match on W7
netsh advfirewall firewall set rule name=all dir=in profile=any protocol=icmpv4:8,any new enable=no
REM for W7 old command line which bring up a message but works
netsh firewall set icmpsetting 8 disable
echo. Done - Press Return for Menu
pause >nul
cls
goto menu

:29nomulticast

netsh advfirewall firewall set rule name="G-Coreserver UDP Multicast all IN" new enable=no
netsh advfirewall firewall set rule name="G-View UDP Multicast all IN" new enable=no
netsh advfirewall firewall set rule name="G-Set UDP Multicast IN" new enable=no
netsh advfirewall firewall set rule name="G-Web UDP Multicast all IN" new enable=no
netsh advfirewall firewall set rule name="GSCServer UDP Multicast all IN" new enable=no
netsh advfirewall firewall set rule name="GSCView UDP Multicast IN" new enable=no

echo. Rules for multicast got disabled - Press Return for Menu
pause >nul
cls
goto menu

:firewallreset
netsh advfirewall reset
echo. Done - Press Return for Menu
pause >nul
cls
goto menu


:resetwithfilesharing

netsh advfirewall reset
REM Netbios enable
netsh advfirewall firewall set rule name=all profile=private localport=137 remoteport=any protocol=udp new enable=yes
netsh advfirewall firewall set rule name=all profile=public localport=137 remoteport=any protocol=udp new enable=yes

netsh advfirewall firewall set rule name=all profile=private localport=138 remoteport=any protocol=udp new enable=yes
netsh advfirewall firewall set rule name=all profile=public localport=138 remoteport=any protocol=udp new enable=yes

netsh advfirewall firewall set rule name=all profile=private localport=139 remoteport=any protocol=tcp new enable=yes
netsh advfirewall firewall set rule name=all profile=public localport=139 remoteport=any protocol=tcp new enable=yes


REM Remotedesktop enable
netsh advfirewall firewall set rule name=all dir=in profile=any localport=3389 remoteport=any protocol=tcp new enable=yes

REM Ping Echo Request enable
REM following line for server 2008 doesnt match on W7
netsh advfirewall firewall set rule name=all dir=in profile=any protocol=icmpv4:8,any new enable=yes
REM for W7 old command line which bring up a message but works
netsh firewall set icmpsetting 8 enable
echo. Done - Press Return for Menu
pause >nul
cls
goto menu

:Multicast


REM Rules added to Support multicast traffic for G-Set G-web and G-View
REM should be done like this but didn't work for ip cams: netsh advfirewall firewall add rule name="G-Coreserver UDP Multicast all IN" dir=in action=allow description="G-Coreserver UDP Multicast all IN" enable=yes program="%gngpath%\GCoreServer.exe" profile=any localport=any remoteport=any protocol=udp remoteip=224.0.0.1-239.255.255.255
REM deleting rules prior to creation to prevent rule dubbing
netsh advfirewall firewall delete rule name="G-Coreserver UDP Multicast all IN"
netsh advfirewall firewall delete rule name="G-View UDP Multicast all IN"
netsh advfirewall firewall delete rule name="G-Set UDP Multicast IN"
netsh advfirewall firewall delete rule name="G-Web UDP Multicast all IN"
netsh advfirewall firewall delete rule name="GSCServer UDP Multicast all IN"
netsh advfirewall firewall delete rule name="GSCView UDP Multicast IN"
netsh advfirewall firewall add rule name="G-Coreserver UDP Multicast all IN" dir=in action=allow description="G-Coreserver UDP Multicast all IN" enable=yes program="%gngpath%\GCoreServer.exe" profile=any localport=any remoteport=any protocol=udp 
netsh advfirewall firewall add rule name="G-View UDP Multicast all IN" dir=in action=allow description="G-View UDP Multicast all IN" enable=yes program="%gngpath%\gview.exe" profile=any localport=any remoteport=any protocol=udp 
netsh advfirewall firewall add rule name="G-Set UDP Multicast IN" dir=in action=allow description="G-Set UDP Multicast IN" enable=yes program="%gngpath%\gset.exe" profile=any localport=any remoteport=any protocol=udp 
netsh advfirewall firewall add rule name="G-Web UDP Multicast all IN" dir=in action=allow description="G-Web UDP Multicast all IN" enable=yes program="%gngpath%\GCoreWeb.exe" profile=any localport=any remoteport=any protocol=udp 
netsh advfirewall firewall add rule name="GSCServer UDP Multicast all IN" dir=in action=allow description="GSCServer UDP Multicast all IN" enable=yes program="%gscpath%\gscserver.exe" profile=any localport=any remoteport=any protocol=udp 
netsh advfirewall firewall add rule name="GSCView UDP Multicast IN" dir=in action=allow description="GSCView UDP Multicast IN" enable=yes program="%gscpath%\gscview.exe" profile=any localport=any remoteport=any protocol=udp 

echo. Done - Press Return for Menu
pause >nul
cls
goto menu

:10glink

REM Rules added to Support G-Link and G-Stats traffic 
REM deleting rules prior to creation to prevent rule dubbing

netsh advfirewall firewall delete rule name="G-Link Port 1021-1025 TCP IN"
netsh advfirewall firewall add rule name="G-Link Port 1021-1025 TCP IN" dir=in action=allow description="G-Link Port 1021-1025 TCP all IN" enable=yes  profile=any localport=1021-1025 remoteport=any protocol=tcp 
netsh advfirewall firewall delete rule name="G-Link Port 5432 TCP IN"
netsh advfirewall firewall add rule name="G-Link Port 5432 TCP IN" dir=in action=allow description="G-Link Port 5432 TCP all IN" enable=yes  profile=any localport=5432 remoteport=any protocol=tcp 
netsh advfirewall firewall delete rule name="G-Link Port 8080 TCP IN"
netsh advfirewall firewall add rule name="G-Link Port 8080 TCP IN" dir=in action=allow description="G-Link Port 8080 TCP all IN" enable=yes  profile=any localport=8080 remoteport=any protocol=tcp 
netsh advfirewall firewall delete rule name="G-Link Port 443-444 TCP IN"
netsh advfirewall firewall add rule name="G-Link Port 443-444 TCP IN" dir=in action=allow description="G-Link Port 443-444 TCP all IN" enable=yes  profile=any localport=443-444 remoteport=any protocol=tcp 
netsh advfirewall firewall delete rule name="G-Link Port 80-81 all IN"
netsh advfirewall firewall add rule name="G-Link Port 80-81 all IN" dir=in action=allow description="G-Link Port 80-81 TCP all IN" enable=yes  profile=any localport=80-81 remoteport=any protocol=tcp 
netsh advfirewall firewall delete rule name="G-Stats Port 9000 all IN"
netsh advfirewall firewall add rule name="G-Stats Port 9000 all IN" dir=in action=allow description="G-Stats Port 9000 TCP all IN" enable=yes  profile=any localport=9000 remoteport=any protocol=tcp 
echo. Done - Press Return for Menu
pause >nul
cls
goto menu

:12GHealthports

REM Rules added to suppport G-Health traffic
REM deleting rules prior to creation to prevent rule dubbing
netsh advfirewall firewall delete rule name="G-Health Port 4002 + 3000 TCP IN"
netsh advfirewall firewall add rule name="G-Health Port 4002 + 3000 TCP IN" dir=in action=allow description="G-Health Port 4002 + 3000 TCP IN" enable=yes  profile=any localport=4002,3000 remoteport=any protocol=tcp 
echo. G-Health ports enabled - Press Return for Menu
pause >nul
cls
goto menu

:32NoGHealthports

netsh advfirewall firewall set rule name="G-Health Port 4002 + 3000 TCP IN" new enable=no

echo. G-Health ports disabled - Press Return for Menu
pause >nul
cls
goto menu

:30noGlink

netsh advfirewall firewall set rule name="G-Link Port 1021-1025 TCP IN" new enable=no
netsh advfirewall firewall set rule name="G-Link Port 5432 TCP IN" new enable=no
netsh advfirewall firewall set rule name="G-Link Port 8080 TCP IN" new enable=no
netsh advfirewall firewall set rule name="G-Link Port 443-444 TCP IN" new enable=no
netsh advfirewall firewall set rule name="G-Link Port 80-81 all IN" new enable=no
netsh advfirewall firewall set rule name="G-Stats Port 9000 all IN" new enable=no

echo. Rules for G-Link / G-Stats got disabled - Press Return for Menu
pause >nul
cls
goto menu


:gcoreproduction
REM Firewallreset to have a common base
netsh advfirewall reset

echo.Microsoft SQL Ports now added and enabled
echo.
netsh advfirewall firewall add rule name="G-Core Port 1433 TCP IN SQL-Server" dir=in action=allow description="G-Core MSSQL Port 1433 IN" enable=yes profile=any localport=1433 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 1434 UDP IN SQL-Browser" dir=in action=allow description="G-Core MSSQL Browser UDP Port 1434 IN" enable=yes profile=any localport=1434 remoteport=any protocol=UDP

REM G-Coreports
echo.G-Core Ports now added and enabled
echo.

netsh advfirewall firewall add rule name="G-Core Port 80 TCP IN" dir=in action=allow description="G-Web Port 80 IN" enable=no profile=any localport=80 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13003 TCP IN" dir=in action=allow description="GscView & GscSetup Port 13003 IN" enable=yes profile=any localport=13003 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13003 TCP OUT" dir=out action=allow description="GscView & GscSetup Port 13003 OUT" enable=yes profile=any localport=13003 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13003 UDP IN ServerList" dir=in action=allow description="G-Core Serverlist UDP Port 13003 IN" enable=yes profile=any localport=13003 remoteport=any protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 13003 UDP OUT ServerList" dir=out action=allow description="G-Core Serverlist UDP Port 13003 OUT" enable=yes profile=any localport=13003 remoteport=any protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 13004 TCP IN" dir=in action=allow description="GscMediaAPI Port 13004 IN" enable=yes profile=any localport=13004 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13004 TCP OUT" dir=out action=allow description="GscMediaAPI Port 13004 OUT" enable=no profile=any localport=13004 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13005 TCP IN" dir=in action=allow description="G-Core RemotePlugin Port 13005 IN" enable=yes profile=any localport=13005 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13005 TCP OUT" dir=out action=allow description="G-Core RemotePlugin Port 13005 OUT" enable=no profile=any localport=13005 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13007 TCP IN" dir=in action=allow description="G-Core Action Server Port 13007 IN" enable=no profile=any localport=13007 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13008 UDP IN SAMList" dir=in action=allow description="G-CoreSAMList Port 13008 UDP IN" enable=yes profile=any localport=13008 remoteport=any protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 13008 TCP IN" dir=in action=allow description="G-Core SAM / Licence Port 13008 IN" enable=yes profile=any localport=13008 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13010 TCP IN" dir=in action=allow description="G-Core Scan Connect Port 13010 IN" enable=no profile=any localport=13010 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13011 TCP IN" dir=in action=allow description="G-Core P2P / IPC Finding Port 13011 IN" enable=yes profile=any localport=13011 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13011 UDP IN" dir=in action=allow description="G-Core P2P / IPC Finding Port 13011 IN" enable=yes profile=any localport=13011 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="G-Core Port 443 TCP IN" dir=in action=allow description="G-Web Port 443 IN" enable=no profile=any localport=80 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Tect FailoverSetup Port 13220 TCP IN" dir=in action=allow description="G-Tect FailoverSetup Port 13220 IN" enable=Yes profile=any localport=13220 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Tect FailoverSetup Port 13220 TCP OUT" dir=out action=allow description="G-Tect FailoverSetup Port 13220 OUT" enable=Yes profile=any localport=13220 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Tect Failover Status Port 13221 TCP IN" dir=in action=allow description="G-Tect Failover Status Port 13221 IN" enable=Yes profile=any localport=13221 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Tect AI Data Port 13222 TCP IN" dir=in action=allow description="G-Tect AI Data Port 13222 IN" enable=Yes profile=any localport=13222 remoteport=any protocol=tcp

REM G-Core Action Gate Rules added but not enabled
netsh advfirewall firewall add rule name="G-Core Port 7777 TCP IN" dir=in action=allow  description="G-Core ActionGate 7777 IN" enable=no profile=any localport=7777 remoteport=any protocol=TCP 

netsh advfirewall firewall add rule name="G-Core Port 7777 TCP OUT" dir=out action=allow  description="G-Core ActionGate 7777 OUT" enable=no profile=any localport=any remoteport=7777 protocol=TCP 


REM G-Streamer Rules were added in early installations before 01.04.2015 and will be deleted because product renamed.
echo.

netsh advfirewall firewall delete rule name="all" dir=in profile=any localport=13015 remoteport=any protocol=tcp
netsh advfirewall firewall delete rule name="all" dir=in profile=any localport=13016 remoteport=any protocol=tcp
netsh advfirewall firewall delete rule name="all" dir=in profile=any localport=13017 remoteport=any protocol=tcp
netsh advfirewall firewall delete rule name="all" dir=in profile=any localport=13018 remoteport=any protocol=tcp

REM add G-Core Streamer Ports because available since Release 1.3.8.42
echo.G-Core Streamer Ports added but disabled
echo.
netsh advfirewall firewall add rule name="G-Core Port 13015 TCP IN Streamer Channel 01" dir=in action=allow description="G-Core/Streamer Port 13015 IN" enable=no profile=any localport=13015 remoteport=any protocol=tcp
netsh advfirewall firewall add rule name="G-Core Port 13016 TCP IN Streamer Channel 02" dir=in action=allow description="G-Core/Streamer Port 13016 IN" enable=no profile=any localport=13016 remoteport=any protocol=tcp
netsh advfirewall firewall add rule name="G-Core Port 13017 TCP IN Streamer Channel 03" dir=in action=allow description="G-Core/Streamer Port 13017 IN" enable=no profile=any localport=13017 remoteport=any protocol=tcp
netsh advfirewall firewall add rule name="G-Core Port 13018 TCP IN Streamer Channel 04" dir=in action=allow description="G-Core/Streamer Port 13018 IN" enable=no profile=any localport=13018 remoteport=any protocol=tcp


netsh advfirewall firewall add rule name="G-Core Port 13020 TCP IN" dir=in action=allow description="G-Core APF Port 13020 IN" enable=yes profile=any localport=13020 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13030 TCP IN" dir=in action=allow description="G-Core Imex Config Port 13030 IN" enable=yes profile=any localport=13030 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13032 TCP IN" dir=in action=allow description="G-Core GngTCServerPort Port 13032 IN" enable=no profile=any localport=13032 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13033 TCP IN" dir=in action=allow description="G-Core GngTCServerWebStreamPort Port 13033 IN" enable=no profile=any localport=13033 remoteport=any protocol=tcp
netsh advfirewall firewall add rule name="G-Core Port 13040 TCP IN" dir=in action=allow description="G-Core HTTP Info Port 13040 IN" enable=yes profile=any localport=13040 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 443 TCP IN" dir=in action=allow description="G-Core HTTPS Info Port 443 IN" enable=yes profile=any localport=443 remoteport=any protocol=tcp

echo. add and enable IPCFinding Ports
echo.

netsh advfirewall firewall add rule name="G-Core Port 13050 TCP IN" dir=in action=allow description="G-Core TopLine finding Port 13050 IN" enable=yes profile=any localport=13050 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13060 TCP IN" dir=in action=allow description="G-Core Sony finding Port 13060 IN" enable=yes profile=any localport=13060 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13062 TCP IN" dir=in action=allow description="G-Core ONVIF G-Core finding Port 13062 IN" enable=yes profile=any localport=13062 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13063 TCP IN" dir=in action=allow description="G-Core ONMVIF G-Finder finding Port 13063 IN" enable=yes profile=any localport=13063 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13064 TCP IN" dir=in action=allow description="G-Core ArecontVision G-Core finding Port 13064 IN" enable=yes profile=any localport=13064 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 13065 TCP IN" dir=in action=allow description="G-Core ArecontVision G-Finder finding Port 13065 IN" enable=yes profile=any localport=13065 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 69 TCP OUT" dir=out action=allow description="G-Core ArecontVision finding broadcast Port 69 OUT" enable=yes profile=any localport=69 remoteport=any protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 2869 UPNP OUT" dir=out action=allow description="G-Core UPNP Remote Port 2869 OUT" enable=yes profile=any localport=any remoteport=2869 protocol=tcp

netsh advfirewall firewall add rule name="G-Core Port 1900 SSDP OUT" dir=out action=allow description="G-Core SSDP Remote Port 1900 OUT" enable=yes profile=any localport=any remoteport=1900 protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 2380 UDP OUT" dir=out action=allow description="G-Core Sony Cameras Remote Port 2380 UDP OUT" enable=yes profile=any localport=any remoteport=2380 protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 2575 UDP OUT" dir=out action=allow description="G-Core TopLine Cameras Remote Port 2575 UDP OUT" enable=yes profile=any localport=any remoteport=2575 protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 3702 UDP OUT" dir=out action=allow description="G-Core ONVIF Cameras Remote Port 3702 UDP OUT" enable=yes profile=any localport=any remoteport=3702 protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 5353 UDP OUT" dir=out action=allow description="G-Core AXIS / E2 MDNS Remote Port 5353 UDP OUT" enable=yes profile=any localport=any remoteport=5353 protocol=UDP

netsh advfirewall firewall add rule name="G-Core Port 6666 UDP OUT" dir=out action=allow description="G-Core E3 / GNSD Remote Port 6666 UDP OUT" enable=yes profile=any localport=any remoteport=6666 protocol=UDP

netsh advfirewall firewall add rule name="G-SIM CCS CamCheck 13200 TCP IN" dir=in action=allow description="CamCheck 13200 TCP IN" enable=yes profile=any localport=13200 remoteport=any protocol=tcp

REM G-SIM Ports
echo.G-SIM Ports now added and enabled
echo.
netsh advfirewall firewall add rule name="G-SIM Port 8090 TCP IN" dir=in action=allow description="G-SIM Server Port 8090 IN" enable=yes profile=any localport=8090 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-SIM Port 8091 TCP IN" dir=in action=allow description="G-SIM Synch Port 8091 IN" enable=yes profile=any localport=8091 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-SIM Port 8098 TCP IN" dir=in action=allow description="G-SIM SAM Proxy Port 8098 IN" enable=yes profile=any localport=8098 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-SIM Port 8099 TCP IN" dir=in action=allow description="G-SIM Agent Port 8099 IN" enable=yes profile=any localport=8099 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-SIM Port 8099 UDP IN" dir=in action=allow description="G-SIM Health Agent Cluster Port UDP 8099 IN" enable=yes profile=any localport=8099 remoteport=any protocol=udp


REM GeViSoft Ports
echo.GeViSoft Ports now added and enabled
echo.
netsh advfirewall firewall add rule name="GeViSoft Port 7700 TCP IN" dir=in action=allow description="GeViSoft Port 7700 IN" enable=yes profile=any localport=7700 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViSoft Port 7701 TCP IN" dir=in action=allow description="GeViSoft Port 7701 IN" enable=yes profile=any localport=7701 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViSoft Port 7704 UDP IN" dir=in action=allow description="GeViServer Port 7704 UDP IN" enable=yes profile=any localport=7704 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="GeViSoft Port 7705 UDP IN" dir=in action=allow description="GeViIo Port 7705 UDP IN" enable=yes profile=any localport=7705 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="GeViSoft Port 7703 TCP IN" dir=in action=allow description="GeViSoft Port 7703 IN" enable=yes profile=any localport=7703 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViSoft Port 7800 TCP IN" dir=in action=allow description="GeViSoft Port 7800 IN" enable=yes profile=any localport=7800 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViSoft Port 7801 TCP IN" dir=in action=allow description="GeViSoft Port 7801 IN" enable=yes profile=any localport=7801 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViSoft Port 7803 TCP IN" dir=in action=allow description="GeViSoft Port 7803 IN" enable=yes profile=any localport=7803 remoteport=any protocol=tcp


netsh advfirewall firewall add rule name="GeViSoft Manager IN" dir=in action=allow program="c:\gevisoft\geviadmin.exe" description="GeViSoft Manager IN" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoft Manager OUT" dir=out action=allow program="c:\gevisoft\geviadmin.exe" description="GeViSoft Manager OUT" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoft GeViSet IN" dir=in action=allow program="c:\gevisoft\geviset.exe" description="GeViSoft GeViSet IN" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoft GeViSet OUT" dir=out action=allow program="c:\gevisoft\geviset.exe" description="GeViSoft GeViSet OUT" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoft GeViRedMonitor IN" dir=in action=allow program="c:\gevisoft\geviredmonitor.exe" description="GeViSoft Redundanz Monitor IN" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoft GeViRedMonitor OUT" dir=out action=allow program="c:\gevisoft\geviredmonitor.exe" description="GeViSoft Redundanz Monitor OUT" enable=yes profile=any


REM Xport Geutebrueck Serial line terminal server module MBeg,CX3
echo.Geutebrueck MBegLan Port now added and enabled
echo.
netsh advfirewall firewall add rule name="XPort Port 10001 IN" dir=in action=allow description="MBegGct & CX3 XPort Port 10001 IN" enable=yes profile=any localport=10001 remoteport=any protocol=tcp


REM Netbios enable
netsh advfirewall firewall set rule name=all profile=private localport=137 remoteport=any protocol=udp new enable=yes
netsh advfirewall firewall set rule name=all profile=public localport=137 remoteport=any protocol=udp new enable=yes

netsh advfirewall firewall set rule name=all profile=private localport=138 remoteport=any protocol=udp new enable=yes
netsh advfirewall firewall set rule name=all profile=public localport=138 remoteport=any protocol=udp new enable=yes

netsh advfirewall firewall set rule name=all profile=private localport=139 remoteport=any protocol=tcp new enable=yes
netsh advfirewall firewall set rule name=all profile=public localport=139 remoteport=any protocol=tcp new enable=yes


REM Remotedesktop enable
netsh advfirewall firewall set rule name=all dir=in profile=any localport=3389 remoteport=any protocol=tcp new enable=yes

REM Multicast 
netsh advfirewall firewall add rule name="G-Coreserver UDP Multicast all IN" dir=in action=allow description="G-Coreserver UDP Multicast all IN" enable=no program="%gngpath%\GCoreServer.exe" profile=any localport=any remoteport=any protocol=udp 
netsh advfirewall firewall add rule name="G-View UDP Multicast all IN" dir=in action=allow description="G-View UDP Multicast all IN" enable=no program="%gngpath%\gview.exe" profile=any localport=any remoteport=any protocol=udp 
netsh advfirewall firewall add rule name="G-Set UDP Multicast IN" dir=in action=allow description="G-Set UDP Multicast IN" enable=no program="%gngpath%\gset.exe" profile=any localport=any remoteport=any protocol=udp 
netsh advfirewall firewall add rule name="G-Web UDP Multicast all IN" dir=in action=allow description="G-Web UDP Multicast all IN" enable=no program="%gngpath%\GCoreWeb.exe" profile=any localport=any remoteport=any protocol=udp 

REM Ping Echo Request enable
REM following line for server 2008 doesnt match on W7
netsh advfirewall firewall set rule name=all dir=in profile=any protocol=icmpv4:8,any new enable=yes
REM for W7 old command line which bring up a message but works
netsh firewall set icmpsetting 8 enable
echo. Done
echo.
goto eof


:gcoreuninstall
REM Firewallreset to have a common base
REM netsh advfirewall reset

REM G-Coreports
echo.G-Core Ports now deleted
echo.

netsh advfirewall firewall delete rule name="G-Core Port 80 TCP IN" dir=in profile=any localport=80 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13003 TCP IN" dir=in profile=any localport=13003 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13003 TCP OUT" dir=out profile=any localport=13003 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13003 UDP IN ServerList" dir=in profile=any localport=13003 remoteport=any protocol=UDP

netsh advfirewall firewall delete rule name="G-Core Port 13003 UDP OUT ServerList" dir=out profile=any localport=13003 remoteport=any protocol=UDP

netsh advfirewall firewall delete rule name="G-Core Port 13004 TCP IN" dir=in profile=any localport=13004 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13004 TCP OUT" dir=out profile=any localport=13004 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13005 TCP IN" dir=in profile=any localport=13005 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13005 TCP OUT" dir=out profile=any localport=13005 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13007 TCP IN" dir=in profile=any localport=13007 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13008 UDP IN SAMList" dir=in profile=any localport=13008 remoteport=any protocol=UDP

netsh advfirewall firewall delete rule name="G-Core Port 13008 TCP IN" dir=in profile=any localport=13008 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13010 TCP IN" dir=in profile=any localport=13010 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13011 TCP IN" dir=in profile=any localport=13011 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13011 UDP IN" dir=in profile=any localport=13011 remoteport=any protocol=udp

netsh advfirewall firewall delete rule name="G-Core Port 443 TCP IN" dir=in profile=any localport=80 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Tect FailoverSetup Port 13220 TCP IN" dir=in profile=any localport=13220 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Tect FailoverSetup Port 13220 TCP OUT" dir=out profile=any localport=13220 remoteport=any protocol=tcp

REM G-Core Action Gate Rules deleted
netsh advfirewall firewall delete rule name="G-Core Port 7777 TCP IN" dir=in  profile=any localport=7777 remoteport=any protocol=TCP 

netsh advfirewall firewall delete rule name="G-Core Port 7777 TCP OUT" dir=out profile=any localport=any remoteport=7777 protocol=TCP 


REM G-Streamer Rules were added in early installations before 01.04.2015 and will be deleted because product renamed.
echo.

netsh advfirewall firewall delete rule name="all" dir=in profile=any localport=13015 remoteport=any protocol=tcp
netsh advfirewall firewall delete rule name="all" dir=in profile=any localport=13016 remoteport=any protocol=tcp
netsh advfirewall firewall delete rule name="all" dir=in profile=any localport=13017 remoteport=any protocol=tcp
netsh advfirewall firewall delete rule name="all" dir=in profile=any localport=13018 remoteport=any protocol=tcp

REM delete G-Core Streamer Ports     available since Release 1.3.8.42
echo.G-Core Streamer Ports added but disabled
echo.
netsh advfirewall firewall delete rule name="G-Core Port 13015 TCP IN Streamer Channel 01" dir=in profile=any localport=13015 remoteport=any protocol=tcp
netsh advfirewall firewall delete rule name="G-Core Port 13016 TCP IN Streamer Channel 02" dir=in profile=any localport=13016 remoteport=any protocol=tcp
netsh advfirewall firewall delete rule name="G-Core Port 13017 TCP IN Streamer Channel 03" dir=in profile=any localport=13017 remoteport=any protocol=tcp
netsh advfirewall firewall delete rule name="G-Core Port 13018 TCP IN Streamer Channel 04" dir=in profile=any localport=13018 remoteport=any protocol=tcp


netsh advfirewall firewall delete rule name="G-Core Port 13020 TCP IN" dir=in profile=any localport=13020 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13030 TCP IN" dir=in profile=any localport=13030 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13040 TCP IN" dir=in profile=any localport=13040 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 443 TCP IN" dir=in profile=any localport=443 remoteport=any protocol=tcp

echo. add and enable IPCFinding Ports
echo.

netsh advfirewall firewall delete rule name="G-Core Port 13050 TCP IN" dir=in profile=any localport=13050 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13060 TCP IN" dir=in profile=any localport=13060 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13062 TCP IN" dir=in profile=any localport=13062 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13063 TCP IN" dir=in profile=any localport=13063 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13064 TCP IN" dir=in profile=any localport=13064 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 13065 TCP IN" dir=in profile=any localport=13065 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 69 TCP OUT" dir=out profile=any localport=69 remoteport=any protocol=UDP

netsh advfirewall firewall delete rule name="G-Core Port 2869 UPNP OUT" dir=out profile=any localport=any remoteport=2869 protocol=tcp

netsh advfirewall firewall delete rule name="G-Core Port 1900 SSDP OUT" dir=out profile=any localport=any remoteport=1900 protocol=UDP

netsh advfirewall firewall delete rule name="G-Core Port 2380 UDP OUT" dir=out profile=any localport=any remoteport=2380 protocol=UDP

netsh advfirewall firewall delete rule name="G-Core Port 2575 UDP OUT" dir=out profile=any localport=any remoteport=2575 protocol=UDP

netsh advfirewall firewall delete rule name="G-Core Port 3702 UDP OUT" dir=out profile=any localport=any remoteport=3702 protocol=UDP

netsh advfirewall firewall delete rule name="G-Core Port 5353 UDP OUT" dir=out profile=any localport=any remoteport=5353 protocol=UDP

netsh advfirewall firewall delete rule name="G-Core Port 6666 UDP OUT" dir=out profile=any localport=any remoteport=6666 protocol=UDP

netsh advfirewall firewall delete rule name="G-SIM CCS CamCheck 13200 TCP IN" dir=in profile=any localport=13200 remoteport=any protocol=tcp

REM G-SIM Ports
echo.G-SIM Ports now deleted
echo.
netsh advfirewall firewall delete rule name="G-SIM Port 8090 TCP IN" dir=in profile=any localport=8090 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-SIM Port 8091 TCP IN" dir=in profile=any localport=8091 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-SIM Port 8098 TCP IN" dir=in profile=any localport=8098 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-SIM Port 8099 TCP IN" dir=in profile=any localport=8099 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-SIM Port 8099 UDP IN" dir=in profile=any localport=8099 remoteport=any protocol=udp


REM GeViSoft Ports
echo.GeViSoft Ports now added and enabled
echo.
netsh advfirewall firewall delete rule name="GeViSoft Port 7700 TCP IN" dir=in profile=any localport=7700 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="GeViSoft Port 7701 TCP IN" dir=in profile=any localport=7701 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="GeViSoft Port 7704 UDP IN" dir=in profile=any localport=7704 remoteport=any protocol=udp

netsh advfirewall firewall delete rule name="GeViSoft Port 7705 UDP IN" dir=in profile=any localport=7705 remoteport=any protocol=udp

netsh advfirewall firewall delete rule name="GeViSoft Port 7703 TCP IN" dir=in profile=any localport=7703 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="GeViSoft Port 7800 TCP IN" dir=in profile=any localport=7800 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="GeViSoft Port 7801 TCP IN" dir=in profile=any localport=7801 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="GeViSoft Port 7803 TCP IN" dir=in profile=any localport=7803 remoteport=any protocol=tcp


netsh advfirewall firewall delete rule name="GeViSoft Manager IN" dir=in program="c:\gevisoft\geviadmin.exe" profile=any

netsh advfirewall firewall delete rule name="GeViSoft Manager OUT" dir=out program="c:\gevisoft\geviadmin.exe" profile=any

netsh advfirewall firewall delete rule name="GeViSoft GeViSet IN" dir=in program="c:\gevisoft\geviset.exe" profile=any

netsh advfirewall firewall delete rule name="GeViSoft GeViSet OUT" dir=out program="c:\gevisoft\geviset.exe" profile=any

netsh advfirewall firewall delete rule name="GeViSoft GeViRedMonitor IN" dir=in program="c:\gevisoft\geviredmonitor.exe" profile=any

netsh advfirewall firewall delete rule name="GeViSoft GeViRedMonitor OUT" dir=out program="c:\gevisoft\geviredmonitor.exe" profile=any


REM Xport Geutebrueck Serial line terminal server module MBeg,CX3
echo.Geutebrueck MBegLan Port now added and enabled
echo.
netsh advfirewall firewall delete rule name="XPort Port 10001 IN" dir=in profile=any localport=10001 remoteport=any protocol=tcp


REM Netbios enable
REM netsh advfirewall firewall set rule name=all profile=private localport=137 remoteport=any protocol=udp new enable=yes
REM netsh advfirewall firewall set rule name=all profile=public localport=137 remoteport=any protocol=udp new enable=yes

REM netsh advfirewall firewall set rule name=all profile=private localport=138 remoteport=any protocol=udp new enable=yes
REM netsh advfirewall firewall set rule name=all profile=public localport=138 remoteport=any protocol=udp new enable=yes

REM netsh advfirewall firewall set rule name=all profile=private localport=139 remoteport=any protocol=tcp new enable=yes
REM netsh advfirewall firewall set rule name=all profile=public localport=139 remoteport=any protocol=tcp new enable=yes


REM Remotedesktop enable
REM netsh advfirewall firewall set rule name=all dir=in profile=any localport=3389 remoteport=any protocol=tcp new enable=yes

REM Multicast 
netsh advfirewall firewall delete rule name="G-Coreserver UDP Multicast all IN" dir=in program="%gngpath%\GCoreServer.exe" profile=any localport=any remoteport=any protocol=udp 
netsh advfirewall firewall delete rule name="G-View UDP Multicast all IN" dir=in program="%gngpath%\gview.exe" profile=any localport=any remoteport=any protocol=udp 
netsh advfirewall firewall delete rule name="G-Set UDP Multicast IN" dir=in program="%gngpath%\gset.exe" profile=any localport=any remoteport=any protocol=udp 
netsh advfirewall firewall delete rule name="G-Web UDP Multicast all IN" dir=in program="%gngpath%\GCoreWeb.exe" profile=any localport=any remoteport=any protocol=udp 

REM Ping Echo Request enable
REM following line for server 2008 doesnt match on W7
netsh advfirewall firewall set rule name=all dir=in profile=any protocol=icmpv4:8,any new enable=yes
REM for W7 old command line which bring up a message but works
netsh firewall set icmpsetting 8 enable
echo. Done
echo.
goto eof



:geviscopeproduction
REM Firewallreset to have a common base
netsh advfirewall reset

REM Geviscopeports
echo.GeViScope Ports now added and enabled
echo.
netsh advfirewall firewall add rule name="GeViScope Port 12003 TCP IN" dir=in action=allow description="GscView & GscSetup Port 12003 IN" enable=yes profile=any localport=12003 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViScope Port 12003 TCP OUT" dir=out action=allow description="GscView & GscSetup Port 12003 OUT" enable=yes profile=any localport=12003 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GscServerList Port 12003 UDP IN" dir=in action=allow description="GeViScope Serverlist UDP Port 12003 IN" enable=yes profile=any localport=12003 remoteport=any protocol=UDP

netsh advfirewall firewall add rule name="GscServerList Port 12003 UDP OUT" dir=out action=allow description="GeViScope Serverlist UDP Port 12003 OUT" enable=no profile=any localport=12003 remoteport=any protocol=UDP

netsh advfirewall firewall add rule name="GeViScope Port 12004 TCP IN" dir=in action=allow description="GscMediaAPI Port 12004 IN" enable=yes profile=any localport=12004 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViScope Port 12004 TCP OUT" dir=out action=allow description="GscMediaAPI Port 12004 OUT" enable=no profile=any localport=12004 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViScope Port 12005 TCP IN" dir=in action=allow description="GeViScope RemotePlugin Port 12005 IN" enable=yes profile=any localport=12005 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViScope Port 12005 TCP OUT" dir=out action=allow description="GeViScope RemotePlugin Port 12005 OUT" enable=no profile=any localport=12005 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViScope Port 12007 TCP IN" dir=in action=allow description="GeViScope TACI Port 12007 IN" enable=yes profile=any localport=12007 remoteport=any protocol=tcp


netsh advfirewall firewall add rule name="GeViScope Port 12008 TCP IN" dir=in action=allow description="GeViScope Licence Port 12008 IN" enable=yes profile=any localport=12008 remoteport=any protocol=tcp
netsh advfirewall firewall add rule name="GeViScope Port 1209 TCP IN" dir=in action=allow description="GeViScope Licence Port 1209 IN" enable=yes profile=any localport=1209 remoteport=any protocol=tcp

echo.GscStreamer Ports added but disabled
echo.
netsh advfirewall firewall add rule name="GscStreamer Channel 01 IN" dir=in action=allow description="GscStreamer Port 12015 IN" enable=no profile=any localport=12015 remoteport=any protocol=tcp
netsh advfirewall firewall add rule name="GscStreamer Channel 02 IN" dir=in action=allow description="GscStreamer Port 12016 IN" enable=no profile=any localport=12016 remoteport=any protocol=tcp
netsh advfirewall firewall add rule name="GscStreamer Channel 03 IN" dir=in action=allow description="GscStreamer Port 12017 IN" enable=no profile=any localport=12017 remoteport=any protocol=tcp
netsh advfirewall firewall add rule name="GscStreamer Channel 04 IN" dir=in action=allow description="GscStreamer Port 12018 IN" enable=no profile=any localport=12018 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViScope Port 12020 TCP IN" dir=in action=allow description="GeViScope APF Port 12020 IN" enable=yes profile=any localport=12020 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViScope Port 80 TCP IN" dir=in action=allow description="GeViScope Web Port 80 IN" enable=no profile=any localport=80 remoteport=any protocol=tcp

REM Axis Camera Event Notification Port

echo.AXIS Camera Event Port now added
echo.
netsh advfirewall firewall add rule name="Axis Camera Port 12006 TCP IN" dir=in action=allow description="Axis Camera Event Notification Port 12006 IN" enable=yes profile=any localport=12006 remoteport=any protocol=tcp


REM Cam2IP Ports
echo.Cam2Ip Ports now added and enabled
echo.
netsh advfirewall firewall add rule name="Cam2Ip Port 12010 TCP IN" dir=in action=allow description="Cam2Ip Port 12010 IN" enable=yes profile=any localport=12010 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="Cam2Ip Port 12011 TCP IN" dir=in action=allow description="Cam2Ip Port 12011 IN" enable=yes profile=any localport=12011 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="Cam2Ip Port 12012 TCP IN" dir=in action=allow description="Cam2Ip Port 12012 IN" enable=yes profile=any localport=any remoteport=12012 protocol=tcp

netsh advfirewall firewall add rule name="Cam2Ip Port 12013 TCP IN" dir=in action=allow description="Cam2Ip Port 12013 IN" enable=yes profile=any localport=any remoteport=12013 protocol=tcp

netsh advfirewall firewall add rule name="Cam2Ip Port 12011 UDP IN" dir=in action=allow description="Cam2Ip Port 12011 IN" enable=yes profile=any localport=12011 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="Cam2Ip Port 12012 UDP IN" dir=in action=allow description="Cam2Ip Port 12012 IN" enable=yes profile=any localport=12012 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="Cam2Ip Port 12013 UDP IN" dir=in action=allow description="Cam2Ip Port 12013 IN" enable=yes profile=any localport=12013 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="Cam2Ip Port 12014 UDP IN" dir=in action=allow description="Cam2Ip Devicelist Port 12014 IN for Device List" enable=yes profile=any localport=12014 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="Cam2Ip Port 12010 UDP OUT" dir=out action=allow description="Cam2Ip Devicelist Port 12010 OUT for Device List" enable=yes profile=any localport=12010 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="Cam2Ip Port 12014 UDP OUT" dir=out action=allow description="Cam2Ip Devicelist Port 12014 OUT for Device List" enable=yes profile=any localport=12014 remoteport=any protocol=udp


REM GeViSoft Ports
echo.GeViSoft Ports now added and enabled
echo.
netsh advfirewall firewall add rule name="GeViSoft Port 7700 TCP IN" dir=in action=allow description="GeViSoft Port 7700 IN" enable=yes profile=any localport=7700 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViSoft Port 7701 TCP IN" dir=in action=allow description="GeViSoft Port 7701 IN" enable=yes profile=any localport=7701 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViSoft Port 7704 UDP IN" dir=in action=allow description="GeViServer Port 7704 UDP IN" enable=yes profile=any localport=7704 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="GeViSoft Port 7705 UDP IN" dir=in action=allow description="GeViIo Port 7705 UDP IN" enable=yes profile=any localport=7705 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="GeViSoft Port 7703 TCP IN" dir=in action=allow description="GeViSoft Port 7703 IN" enable=yes profile=any localport=7703 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViSoft Port 7800 TCP IN" dir=in action=allow description="GeViSoft Port 7800 IN" enable=yes profile=any localport=7800 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViSoft Port 7801 TCP IN" dir=in action=allow description="GeViSoft Port 7801 IN" enable=yes profile=any localport=7801 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="GeViSoft Port 7803 TCP IN" dir=in action=allow description="GeViSoft Port 7803 IN" enable=yes profile=any localport=7803 remoteport=any protocol=tcp


netsh advfirewall firewall add rule name="GeViSoft Manager IN" dir=in action=allow program="c:\gevisoft\geviadmin.exe" description="GeViSoft Manager IN" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoft Manager OUT" dir=out action=allow program="c:\gevisoft\geviadmin.exe" description="GeViSoft Manager OUT" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoft GeViSet IN" dir=in action=allow program="c:\gevisoft\geviset.exe" description="GeViSoft GeViSet IN" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoft GeViSet OUT" dir=out action=allow program="c:\gevisoft\geviset.exe" description="GeViSoft GeViSet OUT" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoft GeViRedMonitor IN" dir=in action=allow program="c:\gevisoft\geviredmonitor.exe" description="GeViSoft Redundanz Monitor IN" enable=yes profile=any

netsh advfirewall firewall add rule name="GeViSoft GeViRedMonitor OUT" dir=out action=allow program="c:\gevisoft\geviredmonitor.exe" description="GeViSoft Redundanz Monitor OUT" enable=yes profile=any


REM Xport Geutebrueck Serial line terminal server module MBeg,CX3
echo.Geutebrueck MBegLan Port now added and enabled
echo.
netsh advfirewall firewall add rule name="XPort Port 10001 IN" dir=in action=allow description="MBegGct & CX3 XPort Port 10001 IN" enable=yes profile=any localport=10001 remoteport=any protocol=tcp


REM Netbios enable
netsh advfirewall firewall set rule name=all profile=private localport=137 remoteport=any protocol=udp new enable=yes
netsh advfirewall firewall set rule name=all profile=public localport=137 remoteport=any protocol=udp new enable=yes

netsh advfirewall firewall set rule name=all profile=private localport=138 remoteport=any protocol=udp new enable=yes
netsh advfirewall firewall set rule name=all profile=public localport=138 remoteport=any protocol=udp new enable=yes

netsh advfirewall firewall set rule name=all profile=private localport=139 remoteport=any protocol=tcp new enable=yes
netsh advfirewall firewall set rule name=all profile=public localport=139 remoteport=any protocol=tcp new enable=yes


REM Remotedesktop enable
netsh advfirewall firewall set rule name=all dir=in profile=any localport=3389 remoteport=any protocol=tcp new enable=yes

REM Multicast
netsh advfirewall firewall add rule name="GSCServer UDP Multicast all IN" dir=in action=allow description="GSCServer UDP Multicast all IN" enable=no program="%gscpath%\gscserver.exe" profile=any localport=any remoteport=any protocol=udp 
netsh advfirewall firewall add rule name="GSCView UDP Multicast IN" dir=in action=allow description="GSCView UDP Multicast IN" enable=no program="%gscpath%\gscview.exe" profile=any localport=any remoteport=any protocol=udp 

REM Ping Echo Request enable
REM following line for server 2008 doesnt match on W7
netsh advfirewall firewall set rule name=all dir=in profile=any protocol=icmpv4:8,any new enable=yes
REM for W7 old command line which bring up a message but works
netsh firewall set icmpsetting 8 enable
echo. Done
echo.


REM G-SIM Ports
:gsiminstall
echo.G-SIM Ports now added and enabled
echo.
netsh advfirewall firewall add rule name="G-SIM Port 8090 TCP IN" dir=in action=allow description="G-SIM Server Port 8090 IN" enable=yes profile=any localport=8090 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-SIM Port 8091 TCP IN" dir=in action=allow description="G-SIM Synch Port 8091 IN" enable=yes profile=any localport=8091 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-SIM Process Data Port 8092 TCP IN" dir=in action=allow description="G-SIM Port 8092 IN" enable=yes profile=any localport=8092 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-SIM Port 8098 TCP IN" dir=in action=allow description="G-SIM SAM Proxy Port 8098 IN" enable=yes profile=any localport=8098 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-SIM Port 8099 TCP IN" dir=in action=allow description="G-SIM Agent Port 8099 IN" enable=yes profile=any localport=8099 remoteport=any protocol=tcp

netsh advfirewall firewall add rule name="G-SIM Port 8099 UDP IN" dir=in action=allow description="G-SIM Health Agent Cluster Port UDP 8099 IN" enable=yes profile=any localport=8099 remoteport=any protocol=udp

netsh advfirewall firewall add rule name="G-SIM Port 13210 AppInstance Mgr TCP IN" dir=in action=allow description="G-SIM Port 13210 AppInstance Mgr TCP IN" enable=yes profile=any localport=13210 remoteport=any protocol=tcp

echo. Done 
echo.
goto eof

REM G-SIM Ports
:gsimuninstall
echo.G-SIM Ports now deleted
echo.
netsh advfirewall firewall delete rule name="G-SIM Port 8090 TCP IN" dir=in profile=any localport=8090 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-SIM Port 8091 TCP IN" dir=in profile=any localport=8091 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-SIM Process Data Port 8092 TCP IN" dir=in profile=any localport=8099 remoteport=any protocol=udp

netsh advfirewall firewall delete rule name="G-SIM Port 8098 TCP IN" dir=in profile=any localport=8098 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-SIM Port 8099 TCP IN" dir=in profile=any localport=8099 remoteport=any protocol=tcp

netsh advfirewall firewall delete rule name="G-SIM Port 8099 UDP IN" dir=in profile=any localport=8099 remoteport=any protocol=udp

netsh advfirewall firewall delete rule name="G-SIM Port 13210 AppInstance Mgr TCP IN" dir=in profile=any localport=13210 remoteport=any protocol=tcp

echo. Done 
echo.
goto eof



:eof
echo.End of Script
echo.
echo.
echo.
exit